<?php 
include 'db.php';

$catid= $_GET['id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Catalogue Selection</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    /* General styling */
    body {
      background-color: #f8f9fa;
    }

    .header {
      padding: 10px 15px;
      background-color: white;
      border-bottom: 1px solid #ddd;
      box-shadow: rgba(50, 50, 93, 0.25) 0px 2px 5px -1px, rgba(0, 0, 0, 0.3) 0px 1px 3px -1px;
    }

    .header h5 {
      margin: 0;
      font-size: 16px;
      font-weight: 600;
    }

    .header button {
      font-size: 14px;
      color: #007bff;
    }


    .nav {
        display: flex;
      background-color: #ffffff;
      border-bottom: 1px solid #ddd;
     
    }

    .nav-item {
        flex: 1;
      text-align: center;
      font-size: 14px;
      color: #888;
      cursor: pointer;
      border-bottom: 2px solid transparent;
    }

    .nav-item .nav-link.active {
        color: #007bff;
      font-weight: bold;
      border-bottom: 2px solid #007bff;
    }

   #product-container {
    display: flex;
    flex-direction: column;
    gap: 10px; 
   }



.card:active {
    cursor: grabbing;
}
    .card {
      cursor: grab;
      margin-right:10px;
      margin-left:10px;
      border: none;
      margin-bottom: 15px;
      border-radius:10px;
      background-color: white ;
    }

    .text-muted {
  font-size: 14px;
}


    .card h6 {
      margin: 0;
      font-size: 18px;
      font-weight: 600;
    }

    .card small {
      color: #6c757d;
    }

    .toggle-switch {
      position: relative;
      width: 30px;
      height: 15px;
    }
    .toggle-switch input {
      display: none;
    }

    .toggle-switch label {
      display: block;
      width: 100%;
      height: 100%;
      background-color: #ccc;
      border-radius: 15px;
      cursor: pointer;
      position: relative;
    }
    /* .toggle-switch label::after {
      content: '';
      position: absolute;
      width: 16px;
      height: 16px;
      background: white;
      border-radius: 50%;
      top: 2px;
      left: 2px;
      transition: all 0.3s;
    } */

    .online-txt {
      font-size: 16px !important;
    }

    .toggle-switch label::after {
      content: '';
      position: absolute;
      width: 14px;
      height: 14px;
      background: white;
      border-radius: 50%;
      top: 0px;
      left: -4px;
      transition: all 0.3s;
    }


    .toggle-switch input:checked + label {
      background-color: #007bff;
    }

    .toggle-switch input:checked + label::after {
      transform: translateX(20px);
    }

    .btn-share {
      font-size: 14px;
      color: #007bff;
    }

    .btn-share img {
      margin-right: 5px;
    }

    
    .online-txt {
      font-size: 14px !important;
    }

    #add-category-btn {
      position: fixed;
      bottom: 20px;
      right: 20px;
      border-radius:25px;
      padding: 12px 20px;
      font-size: 14px;
      text-align: center;
    }
    .positionptag {
    width: 30px; /* Set the diameter of the circle */
    height: 30px; /* Set the diameter of the circle */
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px; /* Adjust font size */
    text-align: center;
    margin: 0; /* Remove margin */
    }

    
    .text-span {
    font-size: 20px;
    font-weight: 600;
}


.card-border {
  border: 1px solid #f1f1f1 !important;
  box-shadow: rgba(50, 50, 93, 0.25) 0px 2px 5px -1px, rgba(0, 0, 0, 0.3) 0px 1px 3px -1px;
  padding: 10px;
}

hr{
  border-top: 1px solid #b9b9c1 !important;
  margin: 15px 0px 8px 0px !important;
}

.p-3 {
    padding: 0.5rem 1rem 0rem 1rem!important;
}

.mb-3 {
  padding: 0.5rem 1rem 0rem 1rem!important;
}

.toggle-section {
  padding: 0px 0px 0px 15px;
}


  </style>
</head>
<body> 

  <!-- Header -->
  <div class="header d-flex justify-content-between align-items-center">
  <div class="col-md-6">
    <i class="fa fa-arrow-left" onclick="window.location='catalogs.php'"></i> <span class="text-span">&nbsp;&nbsp;Category</span>    
    </div>
    <button class="btn d-flex align-items-center">
    <div class="d-flex flex-column text-center me-0">
        <i class="fa fa-angle-up"></i>
        <i class="fa fa-angle-down"></i>
    </div>
    <div style="font-weight: 600; font-size: 17px;" id="move-btn">
       &nbsp; Move
    </div>
</button>


  </div>

 

  <div class="tab-content mt-3">
    
  <?php
// Query to check if the category exists in the categorydata table
$checkCategoryQuery = "SELECT * FROM catagorydata WHERE categoryid = $catid";
$categoryResult = mysqli_query($connection, $checkCategoryQuery);

if ($categoryResult && mysqli_num_rows($categoryResult) > 0) {
    // Category exists, now fetch the products associated with this category
    $productsQuery = "
        SELECT p.*, c.mode FROM product p
        INNER JOIN catagorydata c ON p.id = c.productid
        WHERE c.categoryid = $catid AND c.delete_status = 0
        ORDER BY c.position, c.mode DESC";
    
    $proresult = mysqli_query($connection, $productsQuery);
} else {
    // Category does not exist, fetch products normally
    $productsQuery = "SELECT * FROM product WHERE delete_status = 0";
    $proresult = mysqli_query($connection, $productsQuery);
}

if ($proresult && mysqli_num_rows($proresult) > 0) { ?>
    <div id="product-container">
        <?php while ($row = mysqli_fetch_assoc($proresult)) { ?>
            <div class="card card-border" data-product-id="<?php echo $row['id']; ?>">
                <div class="d-flex align-items-center">
                    <!-- Hidden inputs for category ID and product ID -->
                    <input type="hidden" id="catid" value="<?php echo $catid; ?>">
                    <input type="hidden" id="productid" value="<?php echo $row['id']; ?>">

                    <!-- Product image -->
                    <img src="<?php echo $row['productimage'] ?? 'https://via.placeholder.com/50'; ?>" 
                        alt="Product Image" class="rounded me-3" style="width:70px; height:70px;">

                    <!-- Product details -->
                    <div class="flex-grow-1">
                        <h6 class="mb-0"><?php echo htmlspecialchars($row['productname']); ?></h6>
                        <small class="text-muted"><?php echo htmlspecialchars($row['category'] ?? 'No categories'); ?></small>
                    </div>

                    <!-- Position input -->
                    <div class="ms-auto">
                    <p class="positionptag position-input" style="background-color:#007bff;color:white;border-radius:50%; line-height: 30px; display: none;"><?php echo $row['position'] ?? ''; ?></p>
                    <input type="hidden" class="position-input" value="<?php echo $row['position'] ?? ''; ?>" readonly />

                    </div>
                </div>
                <!-- Separator -->
                <hr class="">

                <div class="d-flex justify-content-between align-items-center mt-0">
                    <div class="d-flex align-items-center toggle-section">
                        <!-- Toggle switch -->
                        <div class="toggle-switch me-2">
                            <input type="checkbox" id="online<?php echo $row['id']; ?>" 
                                    <?php echo ($row['mode'] == '1' ? 'checked' : ''); ?> 
                                    onchange="updateMode(<?php echo $row['id']; ?>)">
                            <label for="online<?php echo $row['id']; ?>"></label>
                        </div>

                        <span  id="status-text-<?php echo $row['id']; ?>" class="online-txt"><?php echo ($row['mode'] == '1' ? 'Online' : 'Offline'); ?></span>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php 
} else {
    echo "<p>No products found.</p>";
}
?>


    </div>
  


<button type="button" class="btn btn-primary" id="add-category-btn" onclick="">+ ADD</button>
      
    
  



  <!-- Bootstrap JS -->
   <!-- Add this before the closing </body> tag -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.8/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Include Sortable.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<!-- Custom Script -->
<script>
    // const dragArea = document.querySelector("#product-container");

    // if (dragArea) {
    //     function setInitialPositions() {
    //         const items = dragArea.querySelectorAll('.card');
    //         items.forEach((item, index) => {
    //             const positionInput = item.querySelector('.position-input');
    //             const positionP = item.querySelector('.positionptag');
    //             if (positionInput) {
    //                 positionInput.value = index + 1; 
    //             }
    //             if (positionP) {
    //                 positionP.textContent = index + 1; 
    //             }
    //         });
    //     }

    //     setInitialPositions();

    //     new Sortable(dragArea, {
    //         animation: 150,
    //         onEnd: function (evt) {
    //             const items = dragArea.querySelectorAll('.card');
    //             items.forEach((item, index) => {
    //                 const positionInput = item.querySelector('.position-input');
    //                 const positionP = item.querySelector('.positionptag');
    //                 if (positionInput) {
    //                     positionInput.value = index + 1; 
    //                 }
    //                 if (positionP) {
    //                     positionP.textContent = index + 1;
    //                 }
    //             });
    //         }
    //     });
    // } else {
    //     console.error("Drag area (product-container) not found.");
    // }
</script>

<script>
  const dragArea = document.querySelector("#product-container");
const moveBtn = document.querySelector("#move-btn");

// Disable drag functionality initially
let sortableInstance = null;

// Function to initialize sortable
function initializeSortable() {
    if (dragArea) {
        // Initialize Sortable.js only when Move button is clicked
        sortableInstance = new Sortable(dragArea, {
            animation: 150,
            onEnd: function (evt) {
                const items = dragArea.querySelectorAll('.card');
                items.forEach((item, index) => {
                    const positionInput = item.querySelector('.position-input');
                    const positionP = item.querySelector('.positionptag');
                    if (positionInput) {
                        positionInput.value = index + 1; // Update position value in input
                    }
                    if (positionP) {
                        positionP.textContent = index + 1; // Update position value in <p>
                    }
                });
            }
        });
    } else {
        console.error("Drag area (product-container) not found.");
    }
}

// Event listener for Move button
moveBtn.addEventListener("click", function () {
    // Enable drag functionality
    if (sortableInstance === null) {
        initializeSortable();
    }
    
 
    // Optionally, disable the button to prevent multiple clicks
    moveBtn.disabled = true;
});

</script>

<script>
    // Add button click handler
    document.getElementById('add-category-btn').addEventListener('click', function () {
        // Collect data from the product container
        let categoryData = [];
        
        // Loop through each card in the product container
        const cards = document.querySelectorAll('#product-container .card');
        cards.forEach((card) => {
            const categoryid = card.querySelector('#catid').value;
            const productid = card.querySelector('#productid').value;
            const position = card.querySelector('.position-input').value;
            const mode = card.querySelector('input[type="checkbox"]').checked ? 1 : 0;

            // Prepare data to send
            categoryData.push({
                categoryid: categoryid,
                productid: productid,
                position: position,
                mode: mode
            });
        });

        // Send the data via AJAX
        fetch('store_category_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(categoryData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                //alert('Data added successfully!');
                window.location="catalogs.php";
            } else {
                alert('Error adding data.');
            }
        })
        .catch((error) => {
            console.error('Error:', error);
        });
    });
</script>


<!-- Toggle ONline/Offline -->
 <script>
  document.addEventListener("DOMContentLoaded", function () {
    // Get all checkboxes on the page
    const checkboxes = document.querySelectorAll("input[type='checkbox']");

    // Add event listener to each checkbox
    checkboxes.forEach(function (checkbox) {
        checkbox.addEventListener("change", function () {
            const productId = this.id.replace('online', '');  // Get the product ID from checkbox ID
            const statusText = document.getElementById('status-text-' + productId);

            if (this.checked) {
                // When checkbox is checked, change status to "Online"
                statusText.textContent = "Online";
            } else {
                // When checkbox is unchecked, change status to "Offline"
                statusText.textContent = "Offline";
            }
        });
    });
});

 </script>


<!-- After Clciks move button -->
 <script>
 document.addEventListener("DOMContentLoaded", function () {
    const moveButton = document.querySelector("button.btn");
    const addCategoryButton = document.getElementById("add-category-btn");
    
    // Get all the position input fields and position tag elements
    const positionInputs = document.querySelectorAll(".position-input");
    const positionTags = document.querySelectorAll(".positionptag");

    // Flag to track if the position inputs are visible or not
    let isMoveMode = false;

    // Add event listener to Move button
    moveButton.addEventListener("click", function () {
        // Toggle Move Mode
        isMoveMode = !isMoveMode;

        // Show or hide the position input fields based on Move Mode
        positionInputs.forEach(function(input, index) {
            if (isMoveMode) {
                input.style.display = "inline-block"; // Show position input
                input.value = index + 1; // Set the value of the input field to the correct position
            } else {
                input.style.display = "none"; // Hide position input
            }
        });

        // Show or hide the position tags based on Move Mode
        positionTags.forEach(function(tag, index) {
            if (isMoveMode) {
                tag.style.display = "inline-block"; // Show position tag
                tag.textContent = index + 1; // Update the position value in the tag
            } else {
                tag.style.display = "none"; // Hide position tag
            }
        });

        // Change the Add button text to Save when in Move Mode
        if (isMoveMode) {
            addCategoryButton.textContent = "SAVE";
        } else {
            addCategoryButton.textContent = "+ ADD";
        }
    });
});


 </script>

</body>
</html>
